function addLine(lineText) {
    $('.content1').append('<div class="line">'+lineText+'</div>');
}



window.addEventListener('bundle:ready', async ({ data: ds, caughtErr: err }) => {

    function displayObj(value) {
        if (jsonEditor == null) {
            jsonEditor = new JsonEditor($('#jsonview'), value, { editable: false });
        } else {
            jsonEditor.load(value);
        }
    }

    function describeSources() {
        addLine('projectName = ' + ds.getProjectName());
        const sources = DataSource.getAllSources();
        for (let e in sources) {
            const source = sources[e];
            const methods = source.getMethods();
            let desc = e;
            if (e !== source.id)
                desc += ' <==> ' + source.id;
            addLine('source: ' +desc);
            for (let e2 in methods) {
                const method = methods[e2];
                addLine('.... method: ' + method.name);
            }
        }
    }

    async function getFunctionContent() {
        const body = {
            verb: 'getFunctionContent',
            functionName: $("#funcname").val(),
            className: $('#classname').val()
        };
        try {
            const respobj = await restRequest('POST', '/rest/$designer', body);
            displayObj(respobj);
        }
        catch (err) {
            displayObj(err);
        }

    }

    async function refreshDisplaySource(event) {
        let source = null;
        if (event.data != null)
            source = event.data.sourceOwner;
        if (source != null) {
            const val = await source.getValue();
            const input = $(`input[data-source="${source.id}"`);
            input.val(val);
        }
            
    }

    async function testGetVal() {
        const val = await source.getValue();
        const x = 1;
    }

    async function callAction(event) {
        const action = $(event.target).attr('data-action');
        const source = DataSource.getSource('emp');
        source.callAction(action);
    }

    async function updateSourceValue(event) {
        const val = event.target.value;
        const $input = $(event.target);
        const sourceid = $input.attr('data-source');
        const source = DataSource.getSource(sourceid);
        if (source != null) {
            source.setValue(null, val);
        }
    }

    async function saveEmp(event) {
        source = DataSource.getSource('emp');
        try {
            const status = await source.save();
            displayObj(status);
        }
        catch (err) {
            displayObj(err);
        }
    }

    async function lockEmp(event) {
        source = DataSource.getSource('emp');
        try {
            const status = await source.lock();
            displayObj(status);
        }
        catch (err) {
            displayObj(err);
        }
    }

    async function unlockEmp(event) {
        source = DataSource.getSource('emp');
        try {
            const status = await source.unlock();
            displayObj(status);
        }
        catch (err) {
            displayObj(err);
        }
    }

	async function getServerInfo(event) {
		const body = {
            verb: 'getWebServerInfo'
        };
        try {
            const respobj = await restRequest('POST', '/rest/$designer', body);
            displayObj(respobj);
        }
        catch (err) {
            displayObj(err);
        }
    }
    
    async function getAllPrivileges(event) {
		const body = {
            verb: 'getPrivileges'
        };
        try {
            const respobj = await restRequest('POST', '/rest/$designer', body);
            displayObj(respobj);
        }
        catch (err) {
            displayObj(err);
        }
    }
    
    async function addAPrivileges(event) {
		const body = {
            verb: 'getPrivileges'
        };
        try {
            const respobj = await restRequest('POST', '/rest/$designer', body);
            respobj.content.privileges.push({
                privilege: 'SomethingManager',
                includes: ['employee']
            });
            const body2 = {
                verb: 'setPrivileges',
                content: respobj.content
            };
            const respobj2 = await restRequest('POST', '/rest/$designer', body2);
            displayObj(respobj2);
        }
        catch (err) {
            displayObj(err);
        }
    }
    
    async function getDocument(event) {
        const body = {
            verb: 'getFileContent',
            root: $("#rootname").val(),
            path: $('#pathname').val(),
            name: $('#docname').val(),
            asText: $('#astext').prop('checked')
        };
        try {
            const respobj = await restRequest('POST', '/rest/$designer', body);
            displayObj(respobj);
        }
        catch (err) {
            displayObj(err);
        }
    }

    async function getEntityPos(event) {
        const sourceEmps = DataSource.getSource('emps');
        const sourceEmp = DataSource.getSource('emp');

        try {
            const pos = await sourceEmps.findElementPosition(sourceEmp);
            $('#entitypos').html('position = ' + pos);
        }
        catch (err) {
            displayObj(err);
        }
    }

    async function copySourceValue(event) {
        const sourceEmps = DataSource.getSource('emps');
        const sourceEmp = DataSource.getSource('emp');
        const sourceEmps2 = DataSource.getSource('emps2');
        const sourceEmp2 = DataSource.getSource('emp2');

        const ok1 = await sourceEmps.copyValueInto(sourceEmps2);
        const ok2 = await sourceEmp.copyValueInto(sourceEmp2);

        await sourceEmp2.refresh();
        const val1 = await sourceEmp2.getValue('firstname');
        const val2 = await sourceEmp2.getValue('lastname');
        const val3 = await sourceEmp2.getValue('fullname');

        const len = await sourceEmps2.getValue('length');

        const obj = {
            ok1: ok1,
            ok2: ok2,
            firstname: val1,
            lastname: val2,
            fullname: val3,
            len: len
        }

        displayObj(obj);


    }

    function keydownHandler(event) {
        if (event.shiftKey) {
           
            $("a").css("color","red");
            $("a").each((i,e)=>{
                let savedHREF = e.getAttribute('data-savedHREF');
                if (savedHREF === '' || savedHREF == null) {
                    savedHREF = e.href;
                    e.setAttribute('data-savedHREF', savedHREF);
                    e.href = e.href+"?newspace=true"
                }
            })
        }
    }

    function keyupHandler(event) {
        
        $("a").css("color","black");
        $("a").each((i,e)=>{
            let savedHREF = e.getAttribute('data-savedHREF');
            if (savedHREF !== '' && savedHREF != null) {
                e.setAttribute('data-savedHREF', '');
                e.href = savedHREF;
            }
        })
    }


    let jsonEditor = null;
    DataSource.buildCatalogDatasources(ds);
   
    DataSource.create({ id: 'emps', type: 'entitysel', dataclass: 'Employee', initialValue:'all', pageSize:10, depth:2 }, ds);
    DataSource.create({ id: 'emp', type: 'entity', dataclass: 'Employee', from: 'emps', initialValue:'first' }, ds);
    DataSource.create({ id: 's1', type: 'auto', from: 'emp.ID' }, ds);
    DataSource.create({ id: 's2', type: 'auto', from: 'emp.firstname' }, ds);
    DataSource.create({ id: 's3', type: 'auto', from: 'emp.lastname' }, ds);

    DataSource.create({ id: 'emps2', type: 'entitysel', dataclass: 'Employee', initialValue:'none', pageSize:10, depth:2 }, ds);
    DataSource.create({ id: 'emp2', type: 'entity', dataclass: 'Employee', from: 'emps2', initialValue: 'none' }, ds);
    DataSource.create({ id: 'xs1', type: 'auto', from: 'emp2.ID' }, ds);
    DataSource.create({ id: 'xs2', type: 'auto', from: 'emp2.firstname' }, ds);
    DataSource.create({ id: 'xs3', type: 'auto', from: 'emp2.lastname' }, ds);
    DataSource.create({ id: 'xs4', type: 'auto', from: 'emp2.fullname' }, ds);

    DataSource.buildDependencies();
    DataSource.createRequestOptimization();
	
    await DataSource.computeInitialValues();

    $('body').on("keydown", keydownHandler);
    $('body').on("keyup", keyupHandler);

    $("#describe").on('click', describeSources);
	$("#getFunctionContent").on('click', getFunctionContent);
    $("#getServerInfo").on('click', getServerInfo);
    $("#getAllPrivileges").on('click', getAllPrivileges);
    $("#addAPrivileges").on('click', addAPrivileges);
    $("#testGetVal").on('click', testGetVal);
    $("#save").on('click', saveEmp);
    $("#lock").on('click', lockEmp);
    $("#unlock").on('click', unlockEmp);
    $("#getDocument").on('click', getDocument);
    $("#getentitypos").on('click', getEntityPos);
    $("#copysource").on('click', copySourceValue);
    $(".toto").durationPicker()

    //let html = '<div class="commanditem">';
    let html = '';
    const actions = ['first', 'previous', 'next', 'last'];
    actions.forEach(action => {
        html += `<button class="bouton" data-action="${action}" id="${'x'+action}">${action}</button>`;
    });
    //html += '</div>';
    $('.actions').html(html);
    $('[data-action]').on('click', callAction);

    html = '';
    const atts = ['ID', 'firstname', 'lastname', 'salary', 'birthdate', 'age', 'employer.name'];
    atts.forEach(attname => {
        const sourceid = 'emp.' + attname;
        html += '<div class="formitem">';
        html += `<span class="sourcelabel">${sourceid}: </span> <input class="inputsource" data-source="${sourceid}" id="x${sourceid}" type="text"/>`;
        html += '</div>';
        const source = DataSource.getSourceOrBuild(sourceid, null, ds);
        source.addListener('changed', refreshDisplaySource);
    });

    DataSource.buildDependencies();
    DataSource.createRequestOptimization();

    $('.detail').html(html);
    $('input[data-source]').on('change', updateSourceValue);
    /*
    let source = DataSource.getSource('s1');
    source.addListener('changed', refreshDisplaySource);
    source = DataSource.getSource('s2');
    source.addListener('changed', refreshDisplaySource);
    source = DataSource.getSource('s3');
    source.addListener('changed', refreshDisplaySource);
    */
    const step2 = true;

    if (step2) {
        source = DataSource.getSource('emps');
        await source.refresh();
    } else {
        source = DataSource.getSource('emp');
        source.hasBeenTouched();
    }

})

